<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\History\Model\History;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;

class HomeController extends Controller
{

    /**
     * @Route({
     *     "fr": "/la-maison",
     *     "en": "/en/house"
     * }, name="home")
     * @Template("@CpCreationSkeleton/theme1/home.html.twig")
     */
    public function indexAction()
    {
        $histories = $this->getDoctrine()->getRepository(History::class)->findBy(['disabled' => 0 ], ['position' => 'ASC']);
        return [
            'classMenu' => 'black',
            "histories" => $histories,
            'subMenu' => true,
        ];
    }
}