<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Contact\Model\Label;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class FooterController extends Controller
{
    /**
     * @Template("@CpCreationSkeleton/theme1/_footer.html.twig")
     *
     * @return array
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $contact = $this->getDoctrine()->getRepository(Contact::class)->findOne();
        $labels  = $this->getDoctrine()->getRepository(Label::class)->findBy([], ['position' => 'ASC']);

        return [
            'contact' => $contact,
            'labels'  => $labels,
        ];
    }
}