<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\SkeletonBundle\Form\ContactType;
use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Depot\Model\Category;
use CpCreation\VitiCore\Depot\Model\Depot;
use CpCreation\VitiCore\Event\Model\Event;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DepotSalonController extends Controller
{
    /**
     * @Route({
     *     "fr": "/ou-nous-trouver",
     *     "en": "/en/where-to-find-us"
     * }, name="find-us")
     * @Template("@CpCreationSkeleton/theme1/depotsalon.html.twig")
     * @param Request $request
     *
     * @return array
     */
    public function indexAction(Request $request)
    {
        $categories = $this->getDoctrine()->getRepository(Category::class)->findBy([],['position' => 'ASC']);
        $salons = $this->getDoctrine()->getRepository(Event::class)->findBy([], ['beginAt' => 'ASC']);

        return [
            'classMenu' => 'black',
            'categories'     => $categories,
            'salons'    => $salons,
        ];
    }

}