<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Product\Model\Product;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class CuveeController extends Controller
{

    /**
     * @Route({
     *     "fr": "/les-cuvees",
     *     "en": "/en/cuvees"
     * }, name="cuvees")
     * @Template("@CpCreationSkeleton/theme1/cuvees.html.twig")
     */
    public function indexAction(Request $request)
    {

        $cuvees    = $this->getDoctrine()->getRepository(Product::class)->findOnlyCuvee();
        $names     = [];
        $refCuvees = [];
        /** @var Product $cuvee */
        foreach ($cuvees as $key => $cuvee) {
            if (in_array($cuvee->getName(), $names)) {
                $prevCuvee = $refCuvees[$cuvee->getName()];
                $cuvee->translate($request->getLocale())->setQuality($prevCuvee['quality'].' & '.$cuvee->getQuality());
                unset($cuvees[$prevCuvee['key']]);
            } else {
                array_push($names, $cuvee->getName());
                $refCuvees[$cuvee->getName()] =
                    [
                        'key'     => $key,
                        'quality' => $cuvee->getQuality(),
                    ];
            }
        }

        return [
            'classMenu' => 'black',
            'subMenu' => true,
            'cuvees'    => $cuvees,
        ];
    }
}