<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Gite\Model\Gite;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

class CottageController extends Controller
{
    /**
     * @param Gite $gite
     *
     * @Route({
     *     "fr": "/gite/{slug}",
     *     "en": "/en/gite/{slug}"
     * }, name="cottage")
     * @Template("@CpCreationSkeleton/theme1/cottage.html.twig")
     * @ParamConverter("gite", converter="translation_converter")
     *
     * @return array
     */
    public function indexAction(Gite $gite)
    {
        return [
            'classMenu' => 'black',
            'cottage'     => $gite
        ];
    }
}