<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\SkeletonBundle\Form\ContactType;
use CpCreation\VitiCore\Contact\Model\Contact;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class ContactController extends Controller
{
    /**
     * @param Request $request
     * @Route({
     *     "fr": "/contact",
     *     "en": "/en/contact"
     * }, name="contact")
     * @Template("@CpCreationSkeleton/theme1/contact.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction(Request $request)
    {
        $contact            = $this->getDoctrine()->getRepository(Contact::class)->findOne();
        $recaptchaKeyPublic = false;
        if ($contact->isRecaptcha()) {
            $recaptchaKeyPublic = $contact->getRecaptchaKeyPublic();
        }
        $form = $this->createForm(ContactType::class);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $contact = $this->getDoctrine()->getRepository(Contact::class)->findOne();
            $data    = $form->getData();
            if (!$this->get('viti-core.recaptcha')->verify($request->get('g-recaptcha-response'))) {
                $this->addFlash('error', $this->get('translator')->trans('contact.form.recaptcha.error'));
            } else {
                $message = (new \Swift_Message('Prise de contact depuis le site Champagne André Boever'))
                    ->setTo($contact->getEmailToMessage())
                    ->setFrom($contact->getEmailFrom(), 'Champagne André Boever')
                    ->setReplyTo($data['email'])
                    ->setBody(
                        '
                    Nom : '.$data['lastname'].'<br/>
                    E-mail : '.$data['email'].'<br/>
                    Message : '.$data['message'].'<br/>
                ', 'text/html'
                    )
                    ->addPart(
                        'Nom : '.$data['lastname'].'E-mail : '.$data['email'].'Message : '.$data['message'].'
                Champagne André Boever', 'text/plain'
                    );

                if ($this->get('mailer')->send($message)) {
                    $this->addFlash('success', $this->get('translator')->trans('contact.form.success'));

                    return $this->redirectToRoute('contact');
                } else {
                    $this->addFlash('error', $this->get('translator')->trans('contact.form.error'));
                }
            }
        }

        return [
            'contact'            => $contact,
            'classMenu'          => 'black',
            'reCaptchaKeyPublic' => $recaptchaKeyPublic,
            'form'               => $form->createView(),
        ];
    }

}