<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\DTO;

use Serenity\CoreBundle\Contract\SearchInterface;
use Serenity\CoreBundle\DTO\SearchDTO;

class TenantSearchDTO extends SearchDTO implements SearchInterface
{
    public const array SORTER = [
        'tenant.createdAt' => 'createdAt',
        'tenant.projects' => ['property' => 'id', 'join' => 'projects', 'method' => 'count'],
    ];

    public static function fromArray(array $data): self
    {
        return new self($data['query'] ?? null, $data['direction'] ?? 'ASC', $data['sorter'] ?? []);
    }

    public function toArray(): array
    {
        return [
            'query' => $this->query,
            'sorter' => $this->sorter,
            'direction' => $this->direction,
        ];
    }
}
