<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\Doctrine\Repository;

use Doctrine\Persistence\ManagerRegistry;
use Serenity\CoreBundle\Doctrine\Repository\BaseRepository;
use Serenity\SaasBundle\Entity\Project;
use Serenity\SaasBundle\Entity\Tenant;
use Symfony\Component\Security\Core\User\UserInterface;

final class ProjectRepository extends BaseRepository
{
    private const string ENTITY_CLASS = Project::class;

    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, self::ENTITY_CLASS);
    }

    /**
     * @return Project[]
     */
    public function getProjectsByTenant(Tenant|UserInterface $tenant): array
    {
        $qb = $this->createQueryBuilder('pj')
          ->andWhere('pj.tenant = :tenant')
          ->setParameter('tenant', $tenant);

        return $qb->getQuery()->getResult();
    }

    public function getProjectsByIdentifier(string $identifier): ?Project
    {
        $qb = $this->createQueryBuilder('pj')
          ->andWhere('pj.identifier = :identifier')
          ->setParameter('identifier', $identifier);

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function getProjectByDomain(string $domain): ?Project
    {
        $qb = $this->createQueryBuilder('pj')
            ->orWhere('pj.domainIn = :domain')
            ->orWhere('pj.domainOut = :domain')
            ->setParameter('domain', $domain);

        return $qb->getQuery()->getOneOrNullResult();
    }
}
