<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\Twig\Components\Menu\Navbar;

use Serenity\CoreBundle\Utils\SerenitySaasContext;
use Serenity\SaasBundle\Doctrine\Repository\ProjectRepository;
use Serenity\SaasBundle\Entity\Project;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent(name: 'SerenityAdmin:Menu:Navbar:Profile', template: '@components/SerenitySaas/Menu/Navbar/Profile.html.twig')]
class Profile extends AbstractController
{
    public function __construct(private readonly ProjectRepository $projectRepository)
    {
    }

    public function getCurrentProject(): ?Project
    {
        $identifier = SerenitySaasContext::$identifierSerenityId;

        if (null === $identifier) {
            return null;
        }

        return $this->projectRepository->getProjectsByIdentifier($identifier);
    }
}
