<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\Resolver;

use Serenity\SaasBundle\Doctrine\Repository\ProjectRepository;
use Serenity\SaasBundle\Entity\Project;
use Symfony\Component\HttpFoundation\RequestStack;

class ProjectResolver
{
    private ?Project $project = null;

    public function __construct(
        private RequestStack $requestStack,
        private ProjectRepository $projectRepository,
    ) {
    }

    public function getProject(): ?Project
    {
        if (null !== $this->project) {
            return $this->project;
        }

        $host = $this->requestStack->getCurrentRequest()?->getHost();

        if (!$host) {
            return null;
        }

        return $this->project = $this->projectRepository
            ->getProjectByDomain($host);
    }

    public function getSerenityId(): ?string
    {
        return $this->getProject()?->getIdentifier(); // ou getId(), selon ton modèle
    }

    public function exists(): bool
    {
        return null !== $this->getProject();
    }
}
