<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\Exception;

use Symfony\Component\HttpKernel\Exception\HttpException;

class MissingHeaderException extends HttpException
{
    public function __construct(string $headerName)
    {
        $message = \sprintf('In SaaS mode, the header %s is required. It is missing from the request headers.', $headerName);
        parent::__construct(400, $message);
    }
}
