<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\EventListener;

use Serenity\AdminBundle\Event\SidebarSuperAdminMenuEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;

#[AsEventListener()]
class SidebarSuperAdminMenuListener
{
    public function __invoke(SidebarSuperAdminMenuEvent $event): void
    {
        $menu = $event->getMenu();
        if (null === $menu) {
            return;
        }
        $menuSaas = $menu->addChild('admin_saas', ['label' => 'Saas'])->setExtra('icon', 'icon-cloud');
        $menuSaas->addChild('admin_saas_tenant', ['label' => 'Tenants', 'route' => 'admin_saas_tenant_list'])->setExtra('icon', 'icon-user-round-search');
    }
}
