<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\SaasBundle\EventListener;

use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\Security\Http\Event\LogoutEvent;

#[AsEventListener(event: LogoutEvent::class, method: 'onLogout')]
final readonly class LogoutListener
{
    public function onLogout(LogoutEvent $event): void
    {
        if ($event->getRequest()->getSession()->has('project_identifier')) {
            $event->getRequest()->getSession()->remove('project_identifier');
        }
    }
}
