<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Glide;

use League\Glide\ServerFactory;

class GlideServerFactory extends ServerFactory
{
    public function getServer(): GlideServer
    {
        $server = new GlideServer(
            $this->getSource(),
            $this->getCache(),
            $this->getApi()
        );

        $server->setSourcePathPrefix($this->getSourcePathPrefix() ?: '');
        $server->setCachePathPrefix($this->getCachePathPrefix() ?: '');
        $server->setGroupCacheInFolders($this->getGroupCacheInFolders());
        $server->setCacheWithFileExtensions($this->getCacheWithFileExtensions());
        $server->setDefaults($this->getDefaults());
        $server->setPresets($this->getPresets());
        $server->setBaseUrl($this->getBaseUrl() ?: '');
        $server->setResponseFactory($this->getResponseFactory());
        $server->setCachePathCallable($this->getCachePathCallable());

        if ($this->getTempDir()) {
            $server->setTempDir($this->getTempDir());
        }

        return $server;
    }

    /**
     * @param array<string, mixed> $config
     */
    public static function create(array $config = []): GlideServer
    {
        return (new self($config))->getServer();
    }
}
