<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Enum;

enum PathStorage: string
{
    case TEMP = '/tmp';         // delete after X days
    case CACHE = '/cache';      // Cache media
    case MEDIA = '/gallery';    // Gallery media
    case INVOICE = '/invoice';  // Invoice directory
    case DOCUMENT = '/document'; // Upload Transactional in entity
    case FILE = '/file';        // Upload Transactional in entity
    case IMAGE = '/image';
    case VIDEO = '/video';

    public static function pathTemp(?string $relativePath = null): string
    {
        return \sprintf(self::TEMP->value.'/%s', ltrim((string) $relativePath, '/'));
    }

    public static function pathMedia(?string $relativePath = null): string
    {
        return \sprintf(self::MEDIA->value.'/%s', ltrim((string) $relativePath, '/'));
    }

    public static function pathDocument(?string $relativePath = null): string
    {
        return \sprintf(self::DOCUMENT->value.'/%s', ltrim((string) $relativePath, '/'));
    }

    public static function pathFile(?string $relativePath = null): string
    {
        return \sprintf(self::FILE->value.'/%s', ltrim((string) $relativePath, '/'));
    }

    public static function pathImage(?string $relativePath = null): string
    {
        return \sprintf(self::IMAGE->value.'/%s', ltrim((string) $relativePath, '/'));
    }

    public static function pathVideo(?string $relativePath = null): string
    {
        return \sprintf(self::VIDEO->value.'/%s', ltrim((string) $relativePath, '/'));
    }

    public static function pathInvoice(?string $relativePath = null): string
    {
        return \sprintf(self::INVOICE->value.'/%s', ltrim((string) $relativePath, '/'));
    }
}
