<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Translatable\Translatable;
use Serenity\CoreBundle\Contract\EmptyInterface;
use Serenity\CoreBundle\Contract\IdentifierInterface;
use Serenity\MediaBundle\Doctrine\Repository\ImageRepository;
use Serenity\MediaBundle\Entity\Translation\MediaTranslation;
use Symfony\Component\HttpFoundation\File\File as BaseFile;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: ImageRepository::class)]
#[Gedmo\TranslationEntity(class: MediaTranslation::class)]
#[Vich\Uploadable]
class Image extends Attachment implements IdentifierInterface, Translatable, EmptyInterface
{
    #[Assert\File(
        maxSize: '10M',
        extensions: ['jpg', 'jpeg', 'png', 'svg']
    )]
    #[Vich\UploadableField(mapping: 'image', fileNameProperty: 'file.name', size: 'file.size', mimeType: 'file.mimeType', originalName: 'file.originalName', dimensions: 'file.dimensions')]
    private ?BaseFile $uploadedFile = null;

    public function getUploadedFile(): ?BaseFile
    {
        return $this->uploadedFile;
    }

    public function setUploadedFile(?BaseFile $file = null): void
    {
        $this->uploadedFile = $file;
        if (null !== $file) {
            $this->setUpdatedAtValue();
        }
    }

    public function isEmpty(): bool
    {
        return !$this->getUploadedFile() && !$this->getFile()?->getName();
    }
}
