<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Serenity\CoreBundle\Contract\IdentifierInterface;
use Serenity\MediaBundle\Doctrine\Repository\FileRepository;
use Symfony\Component\HttpFoundation\File\File as BaseFile;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: FileRepository::class)]
#[Vich\Uploadable]
class File extends Attachment implements IdentifierInterface
{
    #[Assert\File(
        maxSize: '20M',
        extensions: ['pdf']
    )]
    #[Vich\UploadableField(mapping: 'upload_file', fileNameProperty: 'file.name', size: 'file.size', mimeType: 'file.mimeType', originalName: 'file.originalName', dimensions: 'file.dimensions')]
    private ?BaseFile $uploadedFile = null;

    public static function getTranslationEntityClass(): string
    {
        $explodedNamespace = explode('\\', __CLASS__);
        $entityClass = array_pop($explodedNamespace);

        return '\\'.implode('\\', $explodedNamespace).'\\Translation\\'.$entityClass.'Translation';
    }

    public function getUploadedFile(): ?BaseFile
    {
        return $this->uploadedFile;
    }

    public function setUploadedFile(?BaseFile $file = null): void
    {
        $this->uploadedFile = $file;
        if (null !== $file) {
            $this->setUpdatedAtValue();
        }
    }
}
