<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Serenity\CoreBundle\Contract\OwnerInterface;
use Serenity\CoreBundle\Contract\SerenitySaasInterface;
use Serenity\CoreBundle\Trait\AutoIdentifierTrait;
use Serenity\CoreBundle\Trait\OwnerTrait;
use Serenity\CoreBundle\Trait\SerenitySaasTrait;
use Serenity\CoreBundle\Trait\SortableTrait;
use Serenity\CoreBundle\Trait\TimestampTrait;
use Serenity\MediaBundle\Doctrine\Repository\AttachmentRepository;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Entity\File as EmbeddedFile;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: AttachmentRepository::class)]
#[ORM\Table(name: 'serenity_media_attachment')]
#[ORM\InheritanceType('SINGLE_TABLE')]
#[ORM\DiscriminatorColumn(name: 'type', type: 'string')]
#[ORM\DiscriminatorMap(['Image' => Image::class, 'File' => File::class, 'Video' => Video::class, 'Media' => Media::class])]
#[ORM\HasLifecycleCallbacks]
#[Vich\Uploadable]
abstract class Attachment implements SerenitySaasInterface, OwnerInterface
{
    use AutoIdentifierTrait;
    use OwnerTrait;
    use SerenitySaasTrait;
    use SortableTrait;
    use TimestampTrait;

    #[Assert\Length(min: 1, max: 255)]
    #[ORM\Column(type: Types::STRING, nullable: true)]
    private ?string $style = null;

    #[Assert\Length(min: 2, max: 255)]
    #[ORM\Column(type: Types::STRING, nullable: true)]
    private ?string $credit = null;

    #[Gedmo\SortableGroup]
    #[ORM\Column(type: Types::STRING, nullable: true)]
    private ?string $parentId = null;

    #[ORM\Embedded(class: 'Vich\UploaderBundle\Entity\File')]
    protected ?EmbeddedFile $file = null;

    public function __construct()
    {
        $this->file = new EmbeddedFile();
    }

    public function getFile(): ?EmbeddedFile
    {
        return $this->file;
    }

    public function setFile(?EmbeddedFile $file = null): void
    {
        $this->file = $file;
    }

    public function getStyle(): ?string
    {
        return $this->style;
    }

    public function setStyle(?string $style): void
    {
        $this->style = $style;
    }

    public function getCredit(): ?string
    {
        return $this->credit;
    }

    public function setCredit(?string $credit): void
    {
        $this->credit = $credit;
    }

    public function getParentId(): ?string
    {
        return $this->parentId;
    }

    public function setParentId(?string $parentId): void
    {
        $this->parentId = $parentId;
    }
}
