<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Doctrine\Repository;

use Doctrine\Persistence\ManagerRegistry;
use Serenity\MediaBundle\Entity\File;

final class FileRepository extends AttachmentRepository
{
    private const string ENTITY_CLASS = File::class;
    private const string ALIAS = 'file';

    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, self::ENTITY_CLASS, self::ALIAS);
    }
}
