<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Doctrine\Repository;

use Doctrine\Persistence\ManagerRegistry;
use Serenity\CoreBundle\Doctrine\Repository\BaseRepository;
use Serenity\MediaBundle\Contract\AttachmentRepositoryInterface;
use Serenity\MediaBundle\Entity\Attachment;

class AttachmentRepository extends BaseRepository implements AttachmentRepositoryInterface
{
    private const string ENTITY_CLASS = Attachment::class;
    private const string ALIAS = 'attachment';

    public function __construct(ManagerRegistry $registry, string $entityClass = self::ENTITY_CLASS, string $alias = self::ALIAS)
    {
        parent::__construct($registry, $entityClass, $alias);
    }

    public function findOneByFilename(string $filename): ?Attachment
    {
        $qb = $this->createQueryBuilder(self::ALIAS)
          ->andWhere(self::ALIAS.'.file.name = :filename')
          ->setMaxResults(1)
          ->setParameter('filename', $filename);

        return $qb->getQuery()->getOneOrNullResult();
    }
}
