<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Twig\Extension;

use Serenity\MediaBundle\Glide\GenerateUri;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class AssetExtension extends AbstractExtension
{
    public function __construct(
        private readonly GenerateUri $generateUri,
    ) {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('asset_glide', $this->appAsset(...), ['is_safe' => ['html']]),
        ];
    }

    /**
     * @param array<string, string|int|float> $parameters
     */
    public function appAsset(
        string $path,
        string $mapping,
        array $parameters = [],
        int $referenceType = UrlGeneratorInterface::ABSOLUTE_URL,
    ): string {
        return ($this->generateUri)($path, $mapping, $parameters, $referenceType);
    }
}
