<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Namer;

use Serenity\CoreBundle\Utils\SerenitySaasContext;
use Serenity\MediaBundle\Enum\PathStorage;
use Vich\UploaderBundle\Mapping\PropertyMapping;
use Vich\UploaderBundle\Naming\DirectoryNamerInterface;

class VichCustomDirectoryNamer implements DirectoryNamerInterface
{
    public function __construct()
    {
    }

    public function directoryName($object, PropertyMapping $mapping): string
    {
        $serenitySaasId = SerenitySaasContext::$identifierSerenityId;
        $location = ltrim($mapping->getUriPrefix(), '/');

        if (!str_starts_with($location, PathStorage::TEMP->value)) {
            if ($serenitySaasId) {
                $location = $serenitySaasId.'/'.ltrim($location, '/');
            }
        }

        return $location;
    }
}
