<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Form\Type;

use Serenity\MediaBundle\Entity\Image;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ImageType extends AbstractType
{
    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['included_fields'] = $options['included_fields'];
        $view->vars['required_fields'] = $options['required_fields'];
        $view->vars['included_fields_translation'] = $options['included_fields_translation'];
        $view->vars['required_fields_translation'] = $options['required_fields_translation'];
        $view->vars['ux_action'] = $options['ux_action'];
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('uploadedFile', FileType::class, [
            'label' => $options['label'],
        ]);

        $builder->addEventListener(FormEvents::PRE_SET_DATA, [$this, 'onPreSetData']);
    }

    public function onPreSetData(FormEvent $event): void
    {
        $form = $event->getForm();
        if (\in_array('alt', $form->getConfig()->getOptions()['included_fields'], true)) {
            $form->add('alt', TextType::class, [
                'label' => 'Texte alternatif',
                'required' => false,
            ]);
        }

        if (\in_array('style', $form->getConfig()->getOptions()['included_fields'], true)) {
            $form->add('style', TextType::class, [
                'label' => 'Style CSS',
                'required' => false,
            ]);
        }

        if (\in_array('credit', $form->getConfig()->getOptions()['included_fields'], true)) {
            $form->add('credit', TextType::class, [
                'label' => 'Crédit média',
                'required' => false,
            ]);
        }
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setRequired(['included_fields', 'required_fields', 'included_fields_translation', 'required_fields_translation']);
        $resolver->setAllowedTypes('required_fields', ['null', 'string[]']);
        $resolver->setAllowedTypes('included_fields', ['null', 'string[]']);
        $resolver->setAllowedTypes('required_fields_translation', 'string[]');
        $resolver->setAllowedTypes('included_fields_translation', 'string[]');
        $resolver->setDefaults(
            [
                'data_class' => Image::class,
                'required_fields' => [],
                'included_fields' => [],
                'ux_action' => 'upload',
                'block_prefix' => 'image_type',
                'required_fields_translation' => [],
                'included_fields_translation' => [],
            ]
        );
    }
}
