<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Doctrine\Repository;

use Doctrine\Persistence\ManagerRegistry;
use Serenity\CoreBundle\Doctrine\Repository\BaseRepository;
use Serenity\MediaBundle\Contract\AttachmentRepositoryInterface;
use Serenity\MediaBundle\Entity\Image;

final class ImageRepository extends BaseRepository implements AttachmentRepositoryInterface
{
    private const ENTITY_CLASS = Image::class;
    private const ALIAS = 'image';

    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, self::ENTITY_CLASS, self::ALIAS);
    }

    public function findOneByFilename(string $filename): ?Image
    {
        $qb = $this->createQueryBuilder(self::ALIAS)
          ->andWhere(self::ALIAS.'.file.name = :filename')
          ->setMaxResults(1)
          ->setParameter('filename', $filename);

        return $qb->getQuery()->getOneOrNullResult();
    }
}
