<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Cli;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Filesystem;

#[AsCommand(
    name: 'serenity:media:private-key-glide',
    description: 'Secure your Glide image server with HTTP signatures. By signing each request with a private key, no alterations can be made to the URL parameters',
    hidden: false
)]
class GeneratePrivateKeyGlideCli extends Command
{
    protected function configure(): void
    {
        $this
          ->addOption(
              'force',
              null,
              InputOption::VALUE_NONE,
              'Forcer la régénération de la clé même si elle existe déjà'
          );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $filesystem = new Filesystem();
        $keyPath = __DIR__.'/../../../../../config/glide/private.key';

        // Vérifier si le fichier existe déjà
        if ($filesystem->exists($keyPath) && !$input->getOption('force')) {
            $output->writeln('<info>La clé existe déjà. Utilisez --force pour la régénérer.</info>');

            return Command::SUCCESS;
        }

        // Générer une clé de 256 bits (32 octets)
        $key = bin2hex(random_bytes(32));

        // S'assurer que le dossier existe
        $filesystem->mkdir(\dirname($keyPath));

        // Écrire la clé dans le fichier
        file_put_contents($keyPath, $key);

        $output->writeln('<info>Clé 256 bits générée avec succès et enregistrée dans config/glide/private.key.</info>');

        return Command::SUCCESS;
    }
}
