<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Storage;

use League\Flysystem\FilesystemOperator;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\DependencyInjection\Attribute\AutowireLocator;
use Symfony\Component\DependencyInjection\ServiceLocator;

readonly class StorageLocator
{
    public function __construct(
        #[AutowireLocator(services: 'flysystem.storage', indexAttribute: 'storage')]
        private ServiceLocator $locator,
        #[Autowire(env: 'STORAGE_TYPE')]
        private string $storageType,
    ) {
    }

    public function __invoke(): FilesystemOperator
    {
        if (!$this->locator->has($this->storageType)) {
            throw new \RuntimeException("Storage type '{$this->storageType}' not found.");
        }

        return $this->locator->get($this->storageType);
    }
}
