<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Glide;

use League\Glide\Signatures\SignatureFactory;
use Serenity\MediaBundle\Enum\PathStorage;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\File\Exception\NoFileException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

readonly class GenerateUri
{
    public const string FM = 'avif';
    public const int QUALITY = 80;
    public const string FIT = 'cover';
    public const int WIDTH = 600;
    public const int HEIGHT = 600;

    public function __construct(private RouterInterface $router, private Filesystem $filesystem)
    {
    }

    /**
     * @param array<string, string|int|float> $parameters
     */
    public function __invoke(string $path, string $mapping, array $parameters = [], int $referenceType = UrlGeneratorInterface::ABSOLUTE_URL): string
    {
        $defaults = [
            'fm' => self::FM,
            'q' => self::QUALITY,
            'fit' => self::FIT,
            'w' => self::WIDTH,
            'h' => self::HEIGHT,
        ];
        $parameters = array_merge($defaults, $parameters);

        if (!$this->filesystem->exists(__DIR__.'/../../../../../config/glide/private.key')) {
            throw new NoFileException('The private key private.key is missing. config/glide/private.key.');
        }
        if (!\defined(PathStorage::class.'::'.mb_strtoupper($mapping))) {
            throw new \LogicException(\sprintf('The mapping %s is not defined.', $mapping));
        }
        $methodName = 'path'.str_replace(' ', '', ucwords(str_replace('_', ' ', $mapping)));

        if (!method_exists(PathStorage::class, $methodName)) {
            throw new \LogicException(\sprintf('The method %s is not defined in PathStorage::class.', $methodName));
        }

        /** @phpstan-ignore-next-line */
        $path = \call_user_func([PathStorage::class, $methodName], $path);
        $privateKey = $this->filesystem->readFile(__DIR__.'/../../../../../config/glide/private.key');
        $parameters['s'] = SignatureFactory::create($privateKey)->generateSignature($path, $parameters);
        $parameters['path'] = ltrim($path, '/');

        return $this->router->generate('request_image_glide', $parameters, $referenceType);
    }
}
