<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Serenity\CoreBundle\Contract\IdentifierInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity]
#[Vich\Uploadable]
class Video extends Attachment implements IdentifierInterface
{
    #[Assert\File(
        maxSize: '200M',
        extensions: ['mp4']
    )]
    #[Vich\UploadableField(mapping: 'upload_video', fileNameProperty: 'file.name', size: 'file.size', mimeType: 'file.mimeType', originalName: 'file.originalName', dimensions: 'file.dimensions')]
    private ?File $uploadedFile = null;

    public function getUploadedFile(): ?File
    {
        return $this->uploadedFile;
    }

    public function setUploadedFile(?File $file = null): void
    {
        $this->uploadedFile = $file;
        if (null !== $file) {
            $this->setUpdatedAtValue();
        }
    }
}
