<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Contract;

use Doctrine\Common\Collections\Collection;
use Symfony\Component\Uid\Uuid;

interface AttachmentsInterface
{
    public function getId(): Uuid;

    /**
     * @return Collection<int, AttachmentInterface>
     */
    public function getFiles(): Collection;

    /**
     * @param array<int, AttachmentInterface> $files
     */
    public function setFilesFromPostLoad(array $files): void;

    /**
     * Définit un callback permettant de charger les fichiers associés de manière lazy.
     *
     * @param callable(AttachmentsInterface): array<int, AttachmentInterface> $loader
     */
    public function setFilesLoader(callable $loader): void;
}
