<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\MediaBundle\Cli;

use League\Flysystem\FilesystemOperator;
use Serenity\CoreBundle\Utils\SerenitySaasContext;
use Serenity\MediaBundle\Enum\PathStorage;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\Finder\Finder;

#[AsCommand(
    name: 'serenity:media:upload-fixture',
    description: 'Copy fixture Media',
    hidden: false
)]
class UploadStubsCli extends Command
{
    public function __construct(
        private FilesystemOperator $filesystem,
        #[Autowire('%serenity_saas%')]
        private readonly bool $serenitySaas,
    ) {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $io->comment('Copy upload');
        foreach (Finder::create()->in(__DIR__.'/../../fixtures/image/saas')->getIterator() as $file) {
            $relativePath = mb_substr($file, mb_strlen(__DIR__.'/../../fixtures/image/saas'));

            if ($this->filesystem->fileExists(PathStorage::pathImage($relativePath))) {
                $io->comment($relativePath.' is already uploaded');

                continue;
            }

            $contents = file_get_contents($file);
            if (false === $contents) {
                throw new \RuntimeException(\sprintf('Unable to read file: %s', $file));
            }

            $io->comment('Uploading '.PathStorage::pathImage($relativePath).'…');
            $this->filesystem->write(PathStorage::pathImage($relativePath), $contents);
        }

        if ($this->serenitySaas) {
            SerenitySaasContext::$identifierSerenityId = 'sug0s4-f1b3';
        }
        foreach (Finder::create()->in(__DIR__.'/../../fixtures/image/tenant')->getIterator() as $file) {
            $relativePath = mb_substr($file, mb_strlen(__DIR__.'/../../fixtures/image/tenant'));

            if ($this->filesystem->fileExists(PathStorage::pathImage($relativePath))) {
                $io->comment($relativePath.' is already uploaded');

                continue;
            }

            $contents = file_get_contents($file);
            if (false === $contents) {
                throw new \RuntimeException(\sprintf('Unable to read file: %s', $file));
            }

            $io->comment('Uploading '.PathStorage::pathImage($relativePath).'…');

            $this->filesystem->write(PathStorage::pathImage($relativePath), $contents);
        }

        return Command::SUCCESS;
    }
}
