class LazyImage {

  constructor() {
    this.lazyObserver = null;
    document.addEventListener("turbo:load", this.initLazyLoading);
    document.addEventListener("turbo:frame-load", this.initLazyLoading);
    document.addEventListener("turbo:before-fetch-request", () => {
      if (this.lazyObserver) {
        this.lazyObserver.disconnect();
      }
    });
  }

  initLazyLoading() {
    const lazyPictures = document.querySelectorAll("picture[data-lazy], img[data-lazy]");
    if ("IntersectionObserver" in window) {
      // Si un observer existait déjà, on le déconnecte pour éviter les doublons
      if (this.lazyObserver) {
        this.lazyObserver.disconnect();
      }

      this.lazyObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            const element = entry.target;

            // Charger les images dans <picture>
            if (element.tagName === "PICTURE") {
              element.querySelectorAll("source[data-srcset]").forEach((source) => {
                source.setAttribute("srcset", source.getAttribute("data-srcset"));
                source.removeAttribute("data-srcset");

                // Calcul automatique de sizes en fonction de la largeur du conteneur
                const containerWidth = element.offsetWidth;
                if (containerWidth > 0) {
                  source.setAttribute("sizes", `${containerWidth}px`);
                }

              });

              const img = element.querySelector("img[data-srcset]");
              if (img) {
                img.setAttribute("srcset", img.getAttribute("data-srcset"));
                img.removeAttribute("data-srcset");
                // Calcul automatique de sizes en fonction de la largeur du conteneur
                const containerWidth = element.offsetWidth;
                if (containerWidth > 0) {
                  img.setAttribute("sizes", `${containerWidth}px`);
                }

              }

              const imgDataSrc = element.querySelector("img[data-src]");
              if (imgDataSrc) {
                imgDataSrc.setAttribute("src", imgDataSrc.getAttribute("data-src"));
                imgDataSrc.removeAttribute("data-src");
              }

              element.removeAttribute("data-lazy");
            }

            // Charger une image simple <img>
            if (element.tagName === "IMG") {
              if (element.hasAttribute("data-src")) {
                element.setAttribute("src", element.getAttribute("data-src"));
                element.removeAttribute("data-src");
              }

              if (element.hasAttribute("data-srcset")) {
                element.setAttribute("srcset", element.getAttribute("data-srcset"));
                element.removeAttribute("data-srcset");

                // Calcul automatique de sizes en fonction de la largeur du conteneur
                const containerWidth = element.offsetWidth;
                if (containerWidth > 0) {
                  element.setAttribute("sizes", `${containerWidth}px`);
                }
              }

              element.removeAttribute("data-lazy");
              element.classList.remove('opacity-0');
            }

            observer.unobserve(element);
          }
        });
      });

      lazyPictures.forEach((element) => {
        this.lazyObserver.observe(element);
      });
    }
  }
}

// Exporter une unique instance que tous les fichiers partageront
const lazyImage = new LazyImage();
export default lazyImage;
