<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\FrontBundle\Config;

use Serenity\CoreBundle\Contract\ConfigInterface;
use Symfony\Component\Validator\Constraints as Assert;

class FrontConfig implements ConfigInterface
{
    public const string NAME = 'front';

    #[Assert\NotBlank()]
    private string $theme = 'serenity-theme-default';

    public function getName(): string
    {
        return self::NAME;
    }

    public function getTheme(): string
    {
        return $this->theme;
    }

    public function setTheme(string $theme): void
    {
        $this->theme = $theme;
    }

    public function isSaasIdentifierConfig(): bool
    {
        return true;
    }
}
