import { Controller } from '@hotwired/stimulus';
import grapesjs from 'grapesjs';

export default class extends Controller {
    static values = {
        html: String,
        css: String,
        targetHtml: String,
        targetCss: String,
    }

    connect() {
        this.editor = grapesjs.init({
            container: '#gjs',
            height: '600px',
            width: 'auto',
            fromElement: false,
            storageManager: false,
        });
    }

    save() {
        // Exemple pour extraire HTML et CSS
        const html = this.editor.getHtml();
        const css = this.editor.getCss();

        console.log('HTML:', html);
        console.log('CSS:', css);

        // Vous pouvez ensuite envoyer ça via fetch/ajax, etc.
    }
}
