<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Twig\Extension;

use Symfony\Component\HttpFoundation\RequestStack;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;

class EntityGlobalExtension extends AbstractExtension implements GlobalsInterface
{
    public function __construct(private readonly RequestStack $requestStack)
    {
    }

    public function getGlobals(): array
    {
        $request = $this->requestStack->getCurrentRequest();
        if (!$request) {
            return [];
        }

        return [
            'entity' => $request->attributes->get('entity_instance'),
        ];
    }
}
