<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Twig\Extension;

use Doctrine\ORM\EntityManagerInterface;
use Serenity\CoreBundle\Doctrine\Repository\ConfigRepository;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class ConfigExtension extends AbstractExtension
{
    public function __construct(private ConfigRepository $configRepository, private readonly EntityManagerInterface $em)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('config', $this->getConfig(...)),
        ];
    }

    public function getConfig(string $name, bool $disableSerenityIdentifier = false): ?object
    {
        if ($disableSerenityIdentifier) {
            if ($this->em->getFilters()->isEnabled('serenity_saas_filter')) {
                $this->em->getFilters()->disable('serenity_saas_filter');
            }
        }

        $config = $this->configRepository->findOne($name);
        if (null === $config) {
            return null;
        }

        return $config->getValue();
    }
}
