<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Mercure;

use Serenity\CoreBundle\Utils\UserContext;

readonly class TopicsGenerator
{
    /**
     * @return array<string>
     */
    public static function privateWindowIdTopic(string $canonical): array
    {
        if (!UserContext::$identifierWindowId) {
            return [$canonical];
        }

        return [$canonical, strtr(Topics::subscribeUser(UserContext::$identifierWindowId), [
            '{?topic}' => '?topic='.urlencode($canonical),
        ])];
    }

    /**
     * @return array<string>
     */
    public static function privateSessionTopic(string $canonical): array
    {
        if (!UserContext::$identifierSession) {
            return [$canonical];
        }

        return [$canonical, strtr(Topics::subscribeUser(UserContext::$identifierSession), [
            '{?topic}' => '?topic='.urlencode($canonical),
        ])];
    }

    /**
     * @return array<string>
     */
    public static function privateUserIdTopic(string $canonical): array
    {
        if (!UserContext::$identifierUserId) {
            return [$canonical];
        }

        return [$canonical, strtr(Topics::subscribeUser(UserContext::$identifierUserId), [
            '{?topic}' => '?topic='.urlencode($canonical),
        ])];
    }
}
