<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Mercure;

use Symfony\Component\HttpFoundation\Cookie;

readonly class CookieGenerator
{
    public function __construct(
        private JWTSubscriberProvider $JWTSubscriberProvider)
    {
    }

    /**
     * @throws \Exception
     */
    public function generate(): Cookie
    {
        return Cookie::create('mercureAuthorization', $this->JWTSubscriberProvider->getJwt(), 0, '/', null, true, true, false, Cookie::SAMESITE_NONE);
    }
}
