<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Form\Type;

use Serenity\CoreBundle\Doctrine\Contract\NestedTreeInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TreeType extends AbstractType
{
    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        parent::buildView($view, $form, $options);
        $choices = $view->vars['choices'];
        array_walk($choices, function (&$choice) {
            $lvlToString = '';
            /** @var NestedTreeInterface $data */
            $data = $choice->data;
            for ($i = 0; $i <= $data->getLvl(); ++$i) {
                $lvlToString .= '. ';
            }
            $choice->label = $lvlToString.$choice->label;
        });
    }

    public function finishView(FormView $view, FormInterface $form, array $options): void
    {
        parent::finishView($view, $form, $options);
        foreach ($view->children as $key => $child) {
            $child->vars['row_attr'] = array_merge($child->vars['row_attr'], ['data-lvl' => $view->vars['choices'][$key]->data->getLvl()]);
            // Vérifie si la catégorie à des enfants, si oui nous ajoutons un attribut car cette catégorie ne devrait pas contenir de produit
            if ($view->vars['choices'][$key]->data->getChildren()->count() > 0) {
                $child->vars['row_attr'] = array_merge($child->vars['row_attr'], ['data-children' => 1]);
            } else {
                $child->vars['row_attr'] = array_merge($child->vars['row_attr'], ['data-children' => 0]);
            }
        }
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults(
            [
                'class' => NestedTreeInterface::class,
                'choice_label' => function (NestedTreeInterface $choice) {
                    /** @var NestedTreeInterface $choice */
                    $label = '';
                    for ($i = 0; $i <= $choice->getLvl(); ++$i) {
                        $label .= '. ';
                    }

                    return $label;
                },
            ]
        );
    }

    public function getParent(): string
    {
        return EntityType::class;
    }
}
