<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\Repository;

use Doctrine\Persistence\ManagerRegistry;
use Serenity\CoreBundle\Entity\Config;

final class ConfigRepository extends BaseRepository
{
    private const string ENTITY_CLASS = Config::class;
    private const string ALIAS = 'config';

    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, self::ENTITY_CLASS);
    }

    public function findOne(string $name): ?Config
    {
        $qb = $this->createQueryBuilder(self::ALIAS)
            ->andWhere(self::ALIAS.'.name = :name')
            ->setMaxResults(1)
            ->setParameter('name', $name);

        return $qb->getQuery()->getOneOrNullResult();
    }
}
