<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\Contract;

use Doctrine\ORM\QueryBuilder;
use Knp\Component\Pager\Pagination\PaginationInterface;
use Serenity\CoreBundle\Contract\SearchInterface;

/**
 * @template T of object
 */
interface CrudRepositoryInterface extends BaseRepositoryInterface
{
    /**
     * @return PaginationInterface<T>
     */
    public function findAllPagination(int $page, int $limit = 30, ?QueryBuilder $queryBuilder = null): PaginationInterface;

    /**
     * @param array<string, mixed> $searchBy
     */
    public function searchQuery(?SearchInterface $search, array $searchBy = []): ?QueryBuilder;
}
