<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\Contract;

use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ObjectRepository;
use Knp\Component\Pager\Pagination\PaginationInterface;
use Serenity\CoreBundle\Contract\SearchInterface;
use Symfony\Component\Uid\Uuid;

/**
 * @template TEntity of object
 *
 * @extends ObjectRepository<TEntity>
 */
interface BaseRepositoryInterface extends ObjectRepository
{
    public function save(object $object): void;

    public function delete(object $object): void;

    public function remove(object $object): void;

    public function persist(object $object): void;

    public function flush(): void;

    public function findOneById(Uuid|int $id): ?object;

    /**
     * @return array<int, TEntity>
     */
    public function findByPositionOrder(): array;

    /**
     * @return PaginationInterface<TEntity>
     */
    public function findAllPagination(int $page, int $limit = 30, ?QueryBuilder $queryBuilder = null): PaginationInterface;

    /**
     * @param array<string, string|array{property: string, join?: string}> $listSorter
     */
    public function generateSorterQueryBuilder(array $listSorter, SearchInterface $search, QueryBuilder $queryBuilder): QueryBuilder;
}
