<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\DataFixtures\Processor;

use Fidry\AliceDataFixtures\ProcessorInterface;
use Serenity\CoreBundle\Contract\SerenitySaasInterface;

class SaasProcessor implements ProcessorInterface
{
    public function preProcess(string $id, object $object): void
    {
        if (!$object instanceof SerenitySaasInterface) {
            return;
        }

        if ($object->isSaasIdentifierAutoGenerated() && !$object->getSaasIdentifier()) {
            $object->setSaasIdentifier('sug0s4-f1b3');
        }
    }

    public function postProcess(string $id, object $object): void
    {
    }
}
