<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Constraint;

class AssertNormalizer
{
    public static function stripTags(?string $value): string
    {
        return html_entity_decode(strip_tags((string) $value));
    }

    public static function noWhitespace(?string $value): string
    {
        return (string) preg_replace('/\s+/', '', (string) $value);
    }

    public static function trim(?string $value): string
    {
        return trim((string) $value);
    }
}
