<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Notifier\Transport;

use Symfony\Component\Notifier\Message\MessageOptionsInterface;

final class MercureCustomOptions implements MessageOptionsInterface
{
    /**
     * @param array<string> $topics
     */
    public function __construct(
        private readonly array $topics,
        private readonly bool $private = false,
        private readonly ?string $id = null,
        private readonly ?string $type = null,
        private readonly ?int $retry = null,
    ) {
    }

    /**
     * @return array<string>
     */
    public function getTopics(): array
    {
        return $this->topics;
    }

    public function isPrivate(): bool
    {
        return $this->private;
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getRetry(): ?int
    {
        return $this->retry;
    }

    /**
     * @return array{
     *     topics: string[],
     *     private: bool,
     *     id: string|null,
     *     type: string|null,
     *     retry: int|null
     * }
     */
    public function toArray(): array
    {
        return [
            'topics' => $this->topics,
            'private' => $this->private,
            'id' => $this->id,
            'type' => $this->type,
            'retry' => $this->retry,
        ];
    }

    public function getRecipientId(): ?string
    {
        return null;
    }
}
