<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Factory;

class RowLevelSecuritySqlFactory
{
    /**
     * @return array<string>
     */
    public function createEnableSqls(string $policy, string $table, string $role, string $using, string $for, bool $withCheck): array
    {
        return [
            \sprintf('CREATE POLICY %s ON %s FOR %s TO %s USING (%s) WITH CHECK (%d)', $policy, $table, $for, $role, $using, $withCheck),
            \sprintf('GRANT ALL ON TABLE %s TO %s', $table, $role),
            \sprintf('ALTER TABLE %s ENABLE ROW LEVEL SECURITY', $table),
            \sprintf('ALTER TABLE %s FORCE ROW LEVEL SECURITY', $table),
        ];
    }

    /**
     * @return array<string>
     */
    public function createDisableSqls(string $policy, string $table): array
    {
        return [
            \sprintf('DROP POLICY %s ON %s', $policy, $table),
            \sprintf('ALTER TABLE %s DISABLE ROW LEVEL SECURITY', $table),
        ];
    }
}
