<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\EventListener;

use Random\RandomException;
use Serenity\AuthBundle\Model\User;
use Serenity\CoreBundle\Utils\UserContext;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

#[AsEventListener(event: KernelEvents::REQUEST, priority: 100)]
readonly class UserContextListener
{
    public function __construct(private Security $security)
    {
    }

    /**
     * @throws RandomException
     */
    public function __invoke(RequestEvent $event): void
    {
        $windowId = $event->getRequest()->headers->get('X-Window-Id');
        UserContext::$identifierWindowId = $windowId;
        if (!$windowId) {
            UserContext::$identifierWindowId = bin2hex(random_bytes(16));
        }
        $event->getRequest()->headers->set('X-Window-Id', UserContext::$identifierWindowId);
        if ($event->getRequest()->hasSession()) {
            UserContext::$identifierSession = $event->getRequest()->getSession()->getId();
        }
        $user = $this->security->getUser();
        if ($user instanceof User) {
            UserContext::$identifierUserId = $user->getId();
        }
    }
}
