<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\EventListener;

use Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use Doctrine\ORM\Event\PrePersistEventArgs;
use Doctrine\ORM\Events;
use Serenity\CoreBundle\Entity\Config;

#[AsDoctrineListener(event: Events::prePersist)]
readonly class DisableSaasIdentifierConfig
{
    public function __invoke(PrePersistEventArgs $eventArgs): void
    {
        $config = $eventArgs->getObjectManager();
        if (!$config instanceof Config) {
            return;
        }

        if (!$config->getValue()->isSaasIdentifierConfig()) {
            $config->setSaasIdentifier(null);
            $config->setSaasIdentifierAutoGenerated(false);
        }
    }
}
