<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\EventListener;

use Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Events;

#[AsDoctrineListener(event: Events::preFlush)]
class DetachEntityIsEmptyOnPreFlush
{
    public function __invoke(PreFlushEventArgs $args): void
    {
        $em = $args->getObjectManager();
        $uow = $em->getUnitOfWork();

        // Parcours des entités à insérer
        foreach ($uow->getScheduledEntityInsertions() as $entity) {
            if (method_exists($entity, 'isEmpty') && $entity->isEmpty()) {
                $em->detach($entity);
            }
        }

        // Parcours des entités à mettre à jour
        foreach ($uow->getScheduledEntityUpdates() as $entity) {
            if (method_exists($entity, 'isEmpty') && $entity->isEmpty()) {
                $em->detach($entity);
            }
        }
    }
}
