<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class DoctrineRlsPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if (!$container->has('rls.subscriber')) {
            return; // ton listener doit être défini comme service YAML ou PHP
        }

        // Récupère l'event manager principal
        if ($container->hasDefinition('doctrine.dbal.default_connection.event_manager')) {
            $definition = $container->getDefinition('doctrine.dbal.default_connection.event_manager');
            $definition->addMethodCall('addEventSubscriber', [new Reference('rls.subscriber')]);
        }
    }
}
