<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\ValueObject;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Embeddable]
class Email implements \Stringable
{
    protected string $prefix;
    protected string $domain;

    /**
     * @var non-empty-string
     */
    #[ORM\Column(name: 'email', type: Types::STRING)]
    public string $value;

    /**
     * @param non-empty-string $email
     */
    public function __construct(string $email)
    {
        $delimiter = mb_strrpos($email, '@');
        if (false === $delimiter) {
            throw new \InvalidArgumentException('Invalid email format: missing "@" character.');
        }
        $this->prefix = mb_substr($email, 0, $delimiter);
        $this->domain = mb_substr($email, $delimiter + 1);
        $this->value = $email;
    }

    public function prefix(): string
    {
        return $this->prefix;
    }

    public function domain(): string
    {
        return $this->domain;
    }

    public function isEqualTo(self $email): bool
    {
        return $email->value === $this->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
